-- jeli funkcja o takiej nazwie ju istnieje to j usu
IF OBJECT_ID (N'dbo.getProductMembersRec') IS NOT NULL
   DROP FUNCTION dbo.getProductMembersRec
GO

-- utwrz rekurencyjn funkcj przyjmujc dwa parametry i zwracajc jako wynik tabel
CREATE FUNCTION dbo.getProductMembersRec (@MEM_INFO VARCHAR(50), @INCLUDE_PARENT BIT )
RETURNS @ProductMembers TABLE 
(
	MEM_ID		INT NOT NULL,
	MEM_NAME	VARCHAR(50) NOT NULL,
	MEM_DESC	VARCHAR(255) NOT NULL,
	MEM_PID		INT NOT NULL
)
AS
BEGIN

-- utwrz tymczasowy zbir rekordw o nazwie Members, 
-- ktrego struktura jest taka sama jak struktura tabeli wymiaru PRODUCT_PC
WITH Members(MEM_ID, MEM_NAME, MEM_DESC, MEM_PID) AS

-- wstaw do tymczasowego zbioru rekordy z poniszego zapytania
-- pobierajcego odpowiednie elementy ...
    (SELECT MEM_ID, MEM_NAME, MEM_DESC, MEM_PID
		FROM PRODUCT_PC
		WHERE MEM_PID = 
			(SELECT MEM_ID FROM PRODUCT_PC 
						WHERE MEM_NAME = @MEM_INFO OR MEM_ID = 
							(CASE
								WHEN ISNUMERIC(@MEM_INFO)=0 
								THEN 0 
								ELSE @MEM_INFO
							 END)
			)

-- ... do zbioru Memberas docz wyniki poniszego zapytania, 
-- w ktrym tabela wymiaru PRODUCT_PC jest czona ze zbiorem tymczasowym Members
-- w ten sposb chodzimy po poziomach hierarchii wymiaru
   UNION ALL
     SELECT P.MEM_ID, P.MEM_NAME, P.MEM_DESC, P.MEM_PID
     FROM PRODUCT_PC as P
          JOIN Members AS M ON P.MEM_PID = M.MEM_ID
    )

	-- wstaw do tabeli wynikowej wszytkie rekordy ze zbioru tymczasowego Members
   INSERT @ProductMembers
   	SELECT MEM_ID, MEM_NAME, MEM_DESC, MEM_PID
   	FROM Members

 -- Jeli @parametr @INCLUDE_PARENT ma warto 1 
	-- to wstaw do tabeli rekord rodzica
	-- odnajdujc go po nazwie lub identyfikatorze

	IF @INCLUDE_PARENT = 1
	BEGIN
	INSERT @ProductMembers
		SELECT MEM_ID, MEM_NAME, MEM_DESC, MEM_PID
		FROM PRODUCT_PC
		WHERE MEM_NAME = @MEM_INFO 	
			OR MEM_ID = ( CASE
					WHEN ISNUMERIC(@MEM_INFO)=0 
					THEN 0 
					ELSE @MEM_INFO
				       END)

	END

 RETURN
END
